unit FormOsoby;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls, Grids, DBGrids,
  {}
  DataModule,
  UOsoby,
  UTabela;


type
  TFOsoby = class(TForm)
    DBGrid: TDBGrid;
    Panel1: TPanel;
    btnCLOSE: TBitBtn;
    btnINSERT: TBitBtn;
    btnEDIT: TBitBtn;
    btnDELETE: TBitBtn;
    btnWybraneOsoby: TBitBtn;
    procedure btnWybraneOsobyClick(Sender: TObject);
    procedure btnDELETEClick(Sender: TObject);
    procedure btnEDITClick(Sender: TObject);
    procedure btnINSERTClick(Sender: TObject);
    procedure DBGridKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure btnCLOSEClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);

  private

  public
    procedure MyEdit();
    procedure MyInsert();
    procedure MyDelete();
  end;

var
  FOsoby: TFOsoby;

implementation

uses FDlgOsoba;
{$R *.dfm}

procedure TFOsoby.btnCLOSEClick(Sender: TObject);
begin
	Close();
end;

procedure TFOsoby.FormClose(Sender: TObject; var Action: TCloseAction);
begin
	DM.qOsoby.Close();

   Action := caFree;
end;

procedure TFOsoby.FormDestroy(Sender: TObject);
begin
	FOsoby := Nil;
end;

procedure TFOsoby.FormShow(Sender: TObject);
begin
   try
      DM.qOsoby.Open();
	except
      ShowMessage('Nieudane wykonanie zapytania wobec tabeli Osoby');
      Close();
   end;
end;

procedure TFOsoby.btnDELETEClick(Sender: TObject);
begin
   MyDelete();
end;

procedure TFOsoby.btnEDITClick(Sender: TObject);
begin
   MyEdit();
end;

procedure TFOsoby.btnINSERTClick(Sender: TObject);
begin
   MyInsert();
end;

procedure TFOsoby.DBGridKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
   if Key = VK_RETURN then
   begin
      MyEdit();
   end;

   if Key = VK_INSERT then
   begin
      MyInsert();
   end;

   if Key = VK_DELETE then
   begin
      MyDelete();
   end;
end;

procedure TFOsoby.MyDelete();
var
	idosoby : Integer;
	rows    : Integer;
   osoby   : MOsoby;

begin
   rows := DM.qOsoby.RecordCount;
   if rows = 0 then
   begin
      exit;
   end;

   if Application.MessageBox('Usun wskazany rekord?', 'Uwaga', MB_YESNO) = IDNO then
   begin
      exit;
   end;

   osoby := MOsoby.Create();
   try
      idosoby := DM.qOsoby.FieldByName('IDOSOBY').AsInteger;
      osoby.Delete(idosoby);
   finally
      FreeAndNil(osoby);

      DM.qOsoby.Close();
      DM.qOsoby.Open();
   end;
end;

procedure TFOsoby.MyEdit();
var
   bm   : TBookmarkList;
   rows : Integer;

begin
   rows := DM.qOsoby.RecordCount;

   if rows = 0 then
   begin
      exit;
   end;

   if not Assigned(DlgOsoba) then
   begin
      try
         bm := DM.qOsoby.GetBookmark();

         DlgOsoba := TDlgOsoba.Create(Self, DM.qOsoby, true);
         DlgOsoba.ShowModal();
      finally
      	FreeAndNil(DlgOsoba);

         DM.qOsoby.Close();
         DM.qOsoby.Open();

         DM.qOsoby.GotoBookmark(bm);
         DM.qOsoby.FreeBookmark(bm);
      end;
   end;
end;

procedure TFOsoby.btnWybraneOsobyClick(Sender: TObject);
var
	kk        : Integer;
	wiersz    : String;
	nazwisko  : String;
   kom       : String;
	tab_osoby : MOsoby;
   Lista     : TStringList;
   
begin
	wiersz   := '';
	Lista    := TStringList.Create();
   nazwisko := '';

   nazwisko := InputBox('', 'Podaj nazwisko', '');
   if nazwisko = '' then
   begin
      exit;
   end;

   tab_osoby := MOsoby.Create();

   if tab_osoby.DajWybraneNazwiska(nazwisko) then
   begin
      while not tab_osoby.Eof() do
      begin
         tab_osoby.GetRec();
         wiersz := tab_osoby.Rek.Nazwisko + ' ' + tab_osoby.Rek.Imie;
         Lista.Add(wiersz);
         tab_osoby.Next();
      end;
   end;

   if Lista.Count > 0 then
   begin
      kom := '';

      for kk := 0 to Lista.Count-1 do
      begin
         kom := kom + Lista.Strings[kk] + #10#13;
      end;

      ShowMessage(kom);
   end;

   FreeAndNil(tab_osoby);

   Lista.Clear();
   FreeAndNil(Lista);
end;

procedure TFOsoby.MyInsert();
begin
   if not Assigned(DlgOsoba) then
   begin
      try
         DlgOsoba := TDlgOsoba.Create(Self, DM.qOsoby, false);
         DlgOsoba.ShowModal();
      finally
         FreeAndNil(DlgOsoba);

         DM.qOsoby.Close();
         DM.qOsoby.Open();
      end;
   end;
end;

end.

